/*	copen.c	1.7	83/05/13	*/

#include <stdio.h>
#include "cpmio.h"
#include "cpmfio.h"

/************************************************************************
 * NAME:	cpm_file_open()
 *
 * DESCR:	Open the named file in the CPM file structure.
 *		mode tells whether the file is to be read, written or both.
 *
 * ARGS:	
 *
 * RETURNS:	NULL if the file can't be opened, a good C_FILE ptr otherwise.
 *
 * NOTES:	
 ************************************************************************/
C_FILE *
cpm_file_open(struct cpmfs *cpmfs, char *name, char *ext, int mode)
{
	int	 i, index, scnt;
	C_FILE	*fptr;
	char	*malloc();

	if ((index = cpm_searchdir(cpmfs, name, ext)) == -1) {
	    return (NULL);	/* can't find the file	*/
	}
	/* test for legal mode */
	if (!(mode & RW)) {
	    return (NULL);	/* illegal mode given	*/
	}

	for ((i = 0, fptr=cpmfs->c_iob); i < cpmfs->numfiles; i++,fptr++)
	    if (!(fptr->c_flag)) 
		break;
	if (i == cpmfs->numfiles) {
	    return (NULL);	/* too many open files	*/
	}

/*
 * Free file descriptor slot found, initialize field, allocate
 * memory and read first block.
 */

	if ((fptr->c_buf = malloc(cpmfs->blksiz)) == NULL) {
	    return (NULL);	/* ran out of memory	*/
	}
	fptr->cpmfs = cpmfs;
	fptr->c_extno = 0;
	fptr->c_base = fptr->c_buf;
	fptr->c_flag = mode;
	fptr->c_blk = 0;
	fptr->c_ext = index;
	fptr->c_dirp = cpmfs->dirbuf+index;
	fptr->c_seccnt =
		((0xff &(cpmfs->dirbuf+index)->blkcnt) + (cpmfs->seclth/CPMSECSIZ) - 1)
		/ (cpmfs->seclth/CPMSECSIZ);
	scnt = (fptr->c_seccnt > cpmfs->blksiz/cpmfs->seclth) ? cpmfs->blksiz/cpmfs->seclth:fptr->c_seccnt;

	if (!cpm_getblock(fptr->cpmfs,blockno(fptr,0), fptr->c_buf, scnt)) {
	    return (NULL);	/* can't get a new block	*/
	}
	fptr->c_cnt = cpmfs->seclth*scnt;
	fptr->c_seccnt -= scnt;
	return (fptr);
}
